program XpDesigner;

{

XP-Designer (c) 2003 David "mirage228" Fekete, http://www.mirage228.net
Alle rechte vorbehalten.

Anmerkungen:
  Vielen Dank an Luckie fr die Code-Optimierungen (s.Anm.) !

-----------------------------------------
Lizenz [2003-10-30]

DIESES PROGRAMM / DIESER QUELLCODE IST KOSTENLOS.

1. Lizenz
DIESE SOFTWARE WIRD "SO WIE SIE IST" ZUR VERFGUNG GESTELLT, OHNE GEWHRLEISTUNG
IRGENDEINER ART. SIE HABEN DAS RECHT ES WEITER ZU VERTEILEN ODER DEN QUELLCODE ZU
MODIFIZIEREN.

DIESE SOFTWARE DARF NUR FR NICHT KOMMERZIELLE ZWECKE EINGESETZT WERDEN.

2. Haftung
IN KEINEM FALL KANN DER AUTOR HAFTBAR GEMACHT WERDEN FR IRGENDWELCHE SCHDEN,
GLEICH WELCHER ART.

3. COPYRIGHT
Die Software wird sowohl durch Urheberrechtsgesetze und internationale
Urheberrechtsvertrge geschtzt, als auch durch andere Gesetze und Vereinbarungen
ber geistiges Eigentum.

4. Weitergabe
Die Software darf und soll in der hier angebotenen Form weitergegeben werden.
Alle Rechte verbleiben aber beim Autor.

5. Modifizierung des Quellcodes
Der Quellcode darf verndert / modifiziert werden unter folgenden Bedingungen:
1.) Modifizierter Quellcode ist zu kennzeichen.
2.) Der Copyrightvermerk aus dem Dateikopf mu erhalten bleiben.
3.) Der Ursprung des original Quellcodes darf nicht verflscht werden.

}

{ Compiler Schalter }

{ Soll geprft werden, ob Windows XP installiert ist? }
{$DEFINE TESTXP}

uses
  Windows, Messages, CommCtrl, CommDlg;

const
{$EXTERNALSYM OPENFILENAME_SIZE_VERSION_400A}
  OPENFILENAME_SIZE_VERSION_400A = sizeof(TOpenFileNameA) -
    sizeof(pointer) - (2 * sizeof(dword));
{$EXTERNALSYM OPENFILENAME_SIZE_VERSION_400W}
  OPENFILENAME_SIZE_VERSION_400W = sizeof(TOpenFileNameW) -
    sizeof(pointer) - (2 * sizeof(dword));
{$EXTERNALSYM OPENFILENAME_SIZE_VERSION_400}
  OPENFILENAME_SIZE_VERSION_400 = OPENFILENAME_SIZE_VERSION_400A;

  // Globale Konstanten
  NEWLINE = #13#10;  // Luckie: #10#13 in #10#10 gendert
  CLASSNAME = 'WndClass';
  APPVER = '1.3';
  COPYRIGHT = #169 +
    ' 2003 David "mirage228" Fekete [http://www.mirage228.net]';
  APPNAME = 'XP-Designer ' + APPVER;
  WINDOWWIDTH = 400;
  WINDOWHEIGHT = 200;
  FONTNAME = 'MS Sans Serif';
  FONTSIZE = 8;
  FILTER = 'Anwendungen'#0'*.exe'#0'Alle Dateien (*.*)'#0'*.*'#0#0;

  // Manifest file
  MANIFESTTEXT =
    '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>' + NEWLINE +
    '<assembly xmlns="urn:schemas-microsoft-com:asm.v1" manifestVersion="1.0">' + NEWLINE
    +
    '<assemblyIdentity' + NEWLINE +
    ' name="%s"' + NEWLINE +
    ' processorArchitecture="x86"' + NEWLINE +
    ' version="1.0.0.0"' + NEWLINE +
    ' type="win32"/>' + NEWLINE +
    '<description>%s</description>' + NEWLINE +
    '<dependency>' + NEWLINE +
    '   <dependentAssembly>' + NEWLINE +
    '       <assemblyIdentity' + NEWLINE +
    '           type="win32"' + NEWLINE +
    '           name="Microsoft.Windows.Common-Controls"' + NEWLINE +
    '           version="6.0.0.0"' + NEWLINE +
    '           processorArchitecture="x86"' + NEWLINE +
    '           publicKeyToken="6595b64144ccf1df"' + NEWLINE +
    '           language="*"' + NEWLINE +
    '       />' + NEWLINE +
    '   </dependentAssembly>' + NEWLINE +
    '</dependency>' + NEWLINE +
    '</assembly>';


  //////////////////////////////////////////////////////////////////////////////
  // Luckie: ID vereinfacht und vereinheitlicht
  // IDCs
  IDC_LBLPATHEXE = 1;
  IDC_LBLAPPTITLE = 2;
  IDC_LBLABOUT = 3;
  IDC_BTNCLOSE = 4;
  IDC_BTNOPEN = 5;
  IDC_BTNMANIFEST = 6;
  IDC_EDTEXE = 7;
  IDC_EDTAPPTITLE = 8;


var
  hApp: HWND;
  hLabel, hBtn, hEdt: THandle;

  Font: HFont;

////////////////////////////////////////////////////////////////////////////////
// Procedure : RaiseLastError
// Comment   : Luckie

procedure RaiseLastError(hWnd: cardinal);
var
  LastError: DWORD;
  szBuffer, szError, szCaption: array[0..255] of Char;
begin
  LastError := GetLastError;
  wvsprintf(szBuffer, 'Win32-Fehler. Code: %d', PChar(@LastError));
  lstrcat(szBuffer, #13#10);
  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, nil, GetLastError, 0, szError,
    sizeof(szError), nil);
  lstrcat(szBuffer, szError);
  GetWindowText(hWnd, szCaption, sizeof(szCaption));
  MessageBox(hWnd, szBuffer, szCaption, MB_ICONSTOP or MB_APPLMODAL);
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : IsWinXP
// Comment   :

function IsWinXP: Boolean;
var
  OsVinfo: TOSVERSIONINFO;
begin
  Result := False;
  ZeroMemory(@OsVinfo, SizeOf(OsVinfo));
  OsVinfo.dwOSVersionInfoSize := SizeOf(TOSVERSIONINFO);
  if GetVersionEx(OsVinfo) then
  begin
    if OsVinfo.dwPlatformId = VER_PLATFORM_WIN32_WINDOWS then
      Exit;
    if OsVinfo.dwPlatformId = VER_PLATFORM_WIN32_NT then
      Result := (OsVinfo.dwMajorVersion >= 5) and (OsVinfo.dwMinorVersion >= 1);
  end
  else
    Result := False;
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : Format
// Comment   : Assarbad

function Format(fmt: string; params: array of const): string;
var
  pdw1, pdw2: PDWORD;
  i: integer;
  pc: PCHAR;
begin
  pdw1 := nil;
  if length(params) > 0 then
    GetMem(pdw1, length(params) * sizeof(Pointer));
  pdw2 := pdw1;
  for i := 0 to high(params) do
  begin
    pdw2^ := DWORD(PDWORD(@params[i])^);
    inc(pdw2);
  end;
  GetMem(pc, 1024 - 1);
  try
    SetString(Result, pc, wvsprintf(pc, PCHAR(fmt), PCHAR(pdw1)));
  except
    Result := '';
  end;
  if (pdw1 <> nil) then
    FreeMem(pdw1);
  if (pc <> nil) then
    FreeMem(pc);
end;

////////////////////////////////////////////////////////////////////////
// Luckie
// Nachfolgende Borland Prozeduren ersetzt

////////////////////////////////////////////////////////////////////////////////
// Procedure : CutPathname
// Comment   : ExtractFilename

function CutPathname(s: string): string;
var
  i: integer;
begin
  result := s;
  for i := length(s) downto 1 do
    if s[i] = '\' then
    begin
      result := copy(s, i + 1, length(s));
      break;
    end;
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : CutFilename
// Comment   : ExtractFilepath

function CutFilename(s: string): string;
var
  i: integer;
begin
  result := s;
  for i := length(s) downto 1 do
    if s[i] = '\' then
    begin
      result := copy(s, 1, i);
      break;
    end;
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : ChangeFileExt
// Comment   : -

function ChangeFileExt(const szFilename, szNewExt: string): string;
var
  rpos: integer;
begin
  rpos := length(szFilename);
  if (pos('.', szFilename) > 0) then
    while (szFilename[rpos] <> '.') and (rpos > 0) do
      dec(rpos);
  Result := copy(szFilename, 1, rpos - 1) + szNewExt;
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : OpenFile
// Comment   : Luckie
//             leichter wieder zu verwenden

function OpenFile: string;
var
  ofn: TOpenFileName;
  buffer: array[0..MAX_PATH - 1] of Char;
begin
  // zu erst ausnullen
  ZeroMemory(@ofn, sizeof(ofn));
  ZeroMemory(@buffer, sizeof(buffer));
  ofn.lStructSize := SizeOf(TOpenFileName);
  ofn.hWndOwner := hApp;
  ofn.hInstance := hInstance;
  ofn.lpstrFilter := FILTER;
  ofn.lpstrInitialDir := PChar(CutFilename(ParamStr(0)));
  ofn.Flags := OFN_FILEMUSTEXIST or OFN_PATHMUSTEXIST or OFN_LONGNAMES;
  ofn.lpstrTitle := 'Datei ffnen...';
  ofn.lpstrFile := buffer;
  ofn.nMaxFile := 256;
  if GetOpenFileName(ofn) then
    result := string(buffer);
end;

////////////////////////////////////////////////////////////////////////////////
// Procedure : MakeManifestFile
// Comment   : Luckie
//             Der bersichtlichkeit eigene Funktion

function MakeManifestFile(Filename, AppTitle: string): Integer;
var
  s: string;
  F: TextFile;
begin
  s := Format(MANIFESTTEXT, [PChar(AppTitle), PChar(AppTitle)]);
  Filename := Filename + '.manifest';
  DeleteFile(PChar(Filename));
{$IOCHECKS OFF}
  AssignFile(F, Filename);
  Rewrite(F);
  if IOResult = 0 then
  begin
    Write(F, s);
  end;
  CloseFile(F);
{$IOCHECKS ON}
  result := GetLastError();
end;

function WndProc(hWnd: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM):
  LRESULT; stdcall;
var
  x, y: integer;
  Buffer: array[0..MAX_PATH - 1] of Char;
  Filename, AppTitle: string;
  ECode: Integer;
  Loop: Integer;
begin
  Result := 0;

  case uMsg of
    WM_CREATE:
      begin
      {$IFDEF TESTXP}
      if not IsWinXP then
        if MessageBox(hWnd, 'Hinweis: Sie verwenden kein Microsoft Windows XP oder hher.'+
         #10#13#10#13+'Die neuen XP-Visual Styles, die mit einem Manifest ermglicht '+
         'werden, sind erst ab diesem Betriebsystem verfgbar. Mchten Sie XP-Designer '+
         'trotzdem starten?','Kein Windows XP gefunden', MB_ICONQUESTION + MB_YESNO) = idNO then
        begin
          SendMessage(hWnd, WM_DESTROY, 0, 0);
          Exit;
        end;
      {$ENDIF}

        ////////////////////////////////////////////////////////////////////////
        // Luckie
        // Den ganzen Kram etwas formatiert

        // Label fuer Exe Edit
        hLabel := CreateWindowEx(0, 'STATIC',
          'Bitte Pfad zur EXE-Datei eingeben:', WS_VISIBLE or WS_CHILD, 10, 25,
          250, 20, hWnd, IDC_LBLPATHEXE, hInstance, nil);
        // Label fuer Anwendungstitel Edit
        hLabel := CreateWindowEx(0, 'STATIC',
          'Bitte den Namen des Programmes eingeben:', WS_VISIBLE or WS_CHILD,
          10, 65, 250, 20, hWnd, IDC_LBLAPPTITLE, hInstance, nil);
        // About
        hLabel := CreateWindowEx(0, 'STATIC', PChar(AppName + ' - ' +
          Copyright), WS_VISIBLE or WS_CHILD, 5, 110, 400, 20, hWnd,
            IDC_LBLABOUT, hInstance, nil);
        // IDC_BTNCLOSE
        hBtn := CreateWindowEx(0, 'BUTTON', 'Beenden', WS_VISIBLE or WS_CHILD,
          WindowWidth - 135, WindowHeight - 65, 125, 25, hWnd, IDC_BTNCLOSE,
          hInstance, nil);
        // IDC_BTNMANIFEST
        hBtn := CreateWindowEx(0, 'BUTTON', 'Manifest erstellen', WS_VISIBLE or
          WS_CHILD, 10, WindowHeight - 65, 125, 25, hWnd, IDC_BTNMANIFEST,
          hInstance, nil);
        // IDC_BTNOPEN
        hBtn := CreateWindowEx(0, 'BUTTON', '...', WS_VISIBLE or WS_CHILD,
          10 + (WindowWidth - 55), 40, 30, 20, hWnd, IDC_BTNOPEN, hInstance,
          nil);
        // Edit Dateiname
        hEdt := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT', PChar(ParamStr(0)),
          WS_VISIBLE or WS_CHILD or ES_NOHIDESEL, 10, 40, WindowWidth - 20 - 40,
          20, hWnd, IDC_EDTEXE, hInstance, nil);
        // Edit Anwendungstitel
        hEdt := CreateWindowEx(WS_EX_CLIENTEDGE, 'EDIT',
          PChar(ChangeFileExt(CutPathname(ParamStr(0)), '')), WS_VISIBLE or
          WS_CHILD or ES_NOHIDESEL, 10, 80, WindowWidth - 20, 20, hWnd,
          IDC_EDTAPPTITLE, hInstance, nil);

        Font := CreateFont(FONTSIZE, 0, 0, 0, 0, 0, 0, 0, ANSI_CHARSET,
          OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
          DEFAULT_PITCH, FONTNAME);
        ////////////////////////////////////////////////////////////////////////
        // Luckie
        // Schriftart wird in Schleife per ID gesetzt
        if Font <> 0 then
        begin
          for Loop := 1 to 8 do
            SendMessage(GetDlgItem(hWnd, Loop), WM_SETFONT, Integer(Font),
              Integer(true));
        end;
        // Fenster zentrieren
        x := GetSystemMetrics(SM_CXSCREEN);
        y := GetSystemMetrics(SM_CYSCREEN);
        MoveWindow(hWnd, (x div 2) - (WindowWidth div 2),
          (y div 2) - (WindowHeight div 2),
          WindowWidth, WindowHeight, true);
      end;
    WM_DESTROY: PostQuitMessage(0);
    WM_COMMAND:
      begin
        case hiword(wParam) of
          BN_CLICKED:
            begin
              case loword(wParam) of
                IDC_BTNCLOSE: SendMessage(hWnd, WM_DESTROY, 0, 0);
                IDC_BTNOPEN:
                  begin
                    ////////////////////////////////////////////////////////////
                    // Luckie
                    // Oeffnen-Dialog ausgelagert
                    Filename := OpenFile;
                    if Filename <> '' then
                      SetWindowText(GetDlgItem(hWnd, IDC_EDTEXE),
                        pointer(Filename));
                  end;
                IDC_BTNMANIFEST:
                  begin
                    ////////////////////////////////////////////////////////////
                    // Luckie
                    // erstellen der Manifest-datei ausgelagert nur Parameter holen
                    SendMessage(GetDlgItem(hWnd, IDC_EDTEXE), WM_GETTEXT,
                      sizeof(Buffer), Integer(@Buffer));
                    FileName := string(Buffer);
                    SendMessage(GetDlgItem(hWnd, IDC_EDTAPPTITLE), WM_GETTEXT,
                      sizeof(Buffer), Integer(@Buffer));
                    AppTitle := string(Buffer);
                    ECode := MakeManifestFile(Filename, AppTitle);
                    ////////////////////////////////////////////////////////////
                    // Luckie
                    // Auf Fehler testen
                    if ECode <> 0 then
                      RaiseLastError(hWnd) else
                      MessageBox(hWnd, 'Die Manifest-Datei wurde erstellt.',
                                       'Information', MB_ICONINFORMATION + MB_OK); 
                  end; // case IDC_BTNMANIFEST
              end; // case loword(wParam)
            end; // case hiword(wParam) of BN_CLICKED
          EN_CHANGE:
            begin
              case loword(wParam) of
                IDC_EDTEXE:
                  begin
                    SendMessage(GetDlgItem(hWnd, IDC_EDTEXE), WM_GETTEXT,
                      sizeof(Buffer), Integer(@Buffer));
                    Filename := string(Buffer);
                    ////////////////////////////////////////////////////////////
                    // Luckie
                    // Wenn Edit leer, dann Button deaktivieren
                    if Filename = '' then
                      EnableWindow(GetDlgItem(hWnd, IDC_BTNMANIFEST), False)
                    else
                      EnableWindow(GetDlgItem(hWnd, IDC_BTNMANIFEST), True);
                  end;
                IDC_EDTAPPTITLE:
                  begin
                    SendMessage(GetDlgItem(hWnd, IDC_EDTAPPTITLE), WM_GETTEXT,
                      sizeof(Buffer), Integer(@Buffer));
                    AppTitle := string(Buffer);
                    ////////////////////////////////////////////////////////////
                    // Luckie
                    // Wenn Edit leer, dann Button deaktivieren
                    if AppTitle = '' then
                      EnableWindow(GetDlgItem(hWnd, IDC_BTNMANIFEST), False)
                    else
                      EnableWindow(GetDlgItem(hWnd, IDC_BTNMANIFEST), True);
                  end;
              end;
            end; // case hiword(wParam) of EN_CHANGE
        end; // case uMsg of WM_COMMAND
      end // case
  else
    Result := DefWindowProc(hWnd, uMsg, wParam, lParam);
  end;
end;

////////////////////////////////////////////////////
var
  wc: TWndClassEx = (
    cbSize: SizeOf(TWndClassEx);
    Style: CS_HREDRAW or CS_VREDRAW;
    lpfnWndProc: @WndProc;
    cbClsExtra: 0;
    cbWndExtra: 0;
    hbrBackground: COLOR_BACKGROUND + 15; // VCL: clBtnFace
    lpszMenuName: nil;
    lpszClassName: ClassName;
    hIconSm: 0;
    );
  msg: TMsg;

begin
  // Common Controls fr XP Visual Style initialisieren
  InitCommonControls;

  // Erstellung des Fensters vorbereiten
  wc.hInstance := hInstance;
  wc.hIcon := LoadIcon(hInstance, IDI_WINLOGO);
  wc.hCursor := LoadCursor(0, IDC_ARROW);

  // Fenster registrieren
  RegisterClassEx(wc);

  // Fenster erstellen
  hApp := CreateWindowEx(0, CLASSNAME, APPNAME,
    WS_CAPTION or WS_VISIBLE or WS_SYSMENU or WS_MINIMIZEBOX,
    Integer(CW_USEDEFAULT), Integer(CW_USEDEFAULT), WINDOWHEIGHT, WINDOWWIDTH,
    0, 0, hInstance, nil);

  // Nachrichtenschleife
  while (GetMessage(msg, 0, 0, 0)) do
  begin
    TranslateMessage(msg);
    DispatchMessage(msg);
  end;
end.

